clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
aLGS(1,:)=[ 2,-1, 4, 1,-1,"X1","=",  7];
aLGS(2,:)=[-1, 3,-2,-1, 2,"X2","=",  1];
aLGS(3,:)=[ 5, 1, 3,-4, 1,"X3","=", 33];
aLGS(4,:)=[ 3,-2,-2,-2, 3,"X4","=", 24];
aLGS(5,:)=[-4,-1,-5, 3,-4,"X5","=",-49];

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_GLEICHUNGEN = size(aLGS,1);                                                 %Gibt die Anzahl an Zeilen zurck (Parameter 1)
iANZAHL_WERTE = size(aLGS,2)-3;                                                     %Gibt die Anzahl der Spalten zurck (Parameter 2) abzglich 3 ("X";"=";Ergebnis)
if(iANZAHL_GLEICHUNGEN<iANZAHL_WERTE)
   fprintf("Scotty, wir haben ein Problem!\n"); 
   fprintf("Es gibt weniger Gleichungen als Unbekannte!\n"); 
   return;                                                                          %Hoffe das beendet das Skript vorzeitig
end
aA=str2double(aLGS(:,1:iANZAHL_WERTE));
if(issymmetric(aA))                                                                 %ist das gleiche wie if(aA==aA.')
   fprintf("Matrix ist symmetrisch\n");
else
   fprintf("Scotty, wir haben ein Problem!\n");
   fprintf("Matrix ist nicht symmetrisch\n");
end
fprintf("Lineares Gleichungssystem b=A*x \n");
disp(aLGS);

%R_ZERLEGUNG-----------------------------------------------------------------------
aR=zeros(iANZAHL_GLEICHUNGEN,iANZAHL_WERTE);                                        %Initialisierung einer 0-Matrix
for(i=1:1:iANZAHL_GLEICHUNGEN)
    for(j=i:1:iANZAHL_WERTE)                                                        %die Spalte j startet mit jedem Durchlauf bei dem Wert der Zeile i
        %Bearbeitung der Diagonal-Lmmel
        Zwischenspeicher=0;
        for(k=1:1:i-1)
            Zwischenspeicher=Zwischenspeicher+(aR(k,i)^2);
        end
        aR(i,i)=(aA(i,i)-Zwischenspeicher)^0.5;
        if((aA(i,i)-Zwischenspeicher) <= 0)
            fprintf("Matrix ist nicht positiv definit!\n");
            fprintf("Geprft an: R(%u,%u) = %f\n",i,i,(aA(i,i)-Zwischenspeicher));
            return;                                                                 %Ich hoffe das Programm bricht dadurch ab
        else
            fprintf("Postive Definitheit an Stelle: R(%u,%u) = %f erfolgreich geprft\n",i,i,(aA(i,i)-Zwischenspeicher));            
        end
        %Bearbeitung der Nicht-Diagnonal-Lmmel
        Zwischenspeicher = 0;
        for(k=1:1:i-1)
            Zwischenspeicher=Zwischenspeicher+(aR(k,i)*aR(k,j));
        end        
        aR(i,j)=(aA(i,j)-Zwischenspeicher)/aR(i,i);
    end
end
aRT=aR';                                                                            %Erzeugung der transponierten Matrix -> alternativ auch aRT=aR.';
fprintf("R-Matrix = \n");
disp(aR);
fprintf("RT-Matrix = \n");
disp(aRT);

%INITIALISIERUNG_DER_MATRIX_RT*y=b-------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    aRTYB(i,j)="String-Initialisierung";
    for(j=1:1:iANZAHL_WERTE)
        aRTYB(i,j)=aRT(i,j);
    end
    aRTYB(i,j+1)=strcat("Y",num2str(i));
    aRTYB(i,j+2)="=";
    aRTYB(i,j+3)=str2double(aLGS(i,size(aLGS,2)));
end
fprintf("RT*y=b Gleichungssystem = \n");
disp(aRTYB);

%VORWRTSAUFLSUNG-----------------------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    Zwischenspeicher=0;
    for(j=1:1:i-1)
        Zwischenspeicher=Zwischenspeicher+(aRT(i,j)*str2double(aY(j,size(aY,2))));
    end
    aY(i,1)=strcat("Y",num2str(i));
    aY(i,2)="=";
    aY(i,3)=(str2double(aLGS(i,size(aRTYB,2)))-Zwischenspeicher)/aRT(i,i);
end
fprintf("Y-Lsungsvektor = \n");
disp(aY);

%INITIALISIERUNG_DER_MATRIX_R*x=Y--------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    aRXY(i,j)="String-Initialisierung";
    for(j=1:1:iANZAHL_WERTE)
        aRXY(i,j)=aR(i,j);
    end
    aRXY(i,j+1)=strcat("X",num2str(i));
    aRXY(i,j+2)="=";
    aRXY(i,j+3)=aY(i,3);
end
fprintf("R*x=Y Gleichungssystem = \n");
disp(aRXY);

%RCKWRTSAUFLSUNG----------------------------------------------------------------
for(i=iANZAHL_GLEICHUNGEN:-1:1)
    Zwischenspeicher=0;
    for(j=i+1:1:iANZAHL_WERTE)
        Zwischenspeicher=Zwischenspeicher+(str2double(aRXY(i,j))*str2double(aX(j,size(aX,2))));
    end
    aX(i,1)=strcat("X",num2str(i));
    aX(i,2)="=";
    aX(i,3)=(str2double(aRXY(i,size(aRXY,2)))-Zwischenspeicher)/str2double(aRXY(i,i));
end
fprintf("X-Lsungsvektor = \n");
disp(aX);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aLGS aR aRT aRTYB aY aRXY aX                                      %Workspace aufrumen
